
<?php $__env->startSection('contant'); ?>
  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Shared File List</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
          <li class="breadcrumb-item active">Shared File</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
   
<div class="container">
<div class="row">
        <div class="col-lg-12">
          <div class="card recent-sales overflow-auto">
                <div class="card-body" style="overflow-x:auto;">
                  <h5 class="card-title">Recent<span>| Activities</span></h5>
                  <table class="table table-borderless datatable">
                     <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Recent File</th>
                        <th scope="col">Preview</th>
                        <th scope="col">Size</th>
                        <th scope="col">Last Modifier</th>
                        <th scope="col">Change User Access</th>
                        <th scope="col">User Name</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                    
                      <?php $__currentLoopData = $recieveds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                        <th scope="row"><?php echo e($loop->index+1); ?></th>
                        <td><?php echo Str::limit($file->files->title, 20); ?></td>
                        <td>
                         
                         <?php if($file->files->file_type=="image"): ?>
                          <img width="50px" height="50px" src="<?php echo e(Storage::disk('s3')->temporaryUrl($file->files->image??null, '+2 minutes')); ?>">
                         <?php elseif($file->files->file_type=="video"): ?>
                        <video width="50" height="50" controls>
                         <source src="<?php echo e(Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes')); ?>" >
                         </video>
                          <?php else: ?>
                          <iframe width="100px" height="100px" src="<?php echo e(Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes')); ?>"></iframe>
                          <?php endif; ?>
                        </td>
                        <td><a href="#" class="text-primary"><?php echo e($file->files->size); ?></a></td>
                        <td><?php echo e($file->updated_at); ?></td>
                        <td>
                          <?php $type=$file->user_type ?>
                          <select class="user_type" data-id="<?php echo e($file->id); ?>">
                            <option value="1" <?php if($type=="1"): ?> selected <?php endif; ?>>Admin</option> 
                            <option value="2" <?php if($type=="2"): ?> selected <?php endif; ?>>Editor</option>
                            <option value="3" <?php if($type=="3"): ?> selected <?php endif; ?>>Viewer</option>
                          </select>
                        </td>
                        <td>
                          <?php echo e($file->users->name); ?>

                        </td>
                        

                        <td> 
                           
                        <div class="col-lg-4" style="margin-top: 10px;">
                         <a type="button" href="<?php echo e(route('share.file.delete',$file->id)); ?>" class="btn btn-danger">Delete</a>
                          </div>
                          
                      </td>
                  </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              </div>
        </div>
      </div>
</div>
       </main><!-- End #main -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('footer-script'); ?>  
<script>

$('.user_type').on('change',function(){
  var user_type=$(this).val();
  var id=$(this).data('id');
  $.ajax({
  url:'<?php echo e(route("change.user_type")); ?>',
  data:{
    'user_type':user_type,
    'id':id,
  }
  });
});  

</script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/workspacepro/public_html/resources/views/admin/share/share.blade.php ENDPATH**/ ?>