<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\RecievedController;
use App\Http\Controllers\ShareController;
use App\Http\Controllers\RequestController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/login',[AdminController::class,'login'])->name('login');
Route::post('/user/login',[AdminController::class,'makeLogin'])->name('makeLogin');



/*Auth and Active_User Middleware Route*/
Route::group(['middleware'=>['auth', 'active_user']],function(){

     /*Profile route*/
     Route::get('/profile',[AdminController::class,'profile'])->name('profile');

     /*File route*/
     Route::post('/file/upload',[FileController::class,'store'])->name('upload.file');
     Route::get('/file/delete/{id}',[FileController::class,'destroy'])->name('delete.file');
     Route::get('/file/download/{id}',[FileController::class,'download'])->name('download.file');

     /*share and recieve route*/
     Route::post('/file/share/',[FileController::class,'share'])->name('share.file');
     Route::post('/file/recieve/',[RecievedController::class,'store'])->name('recieve.file.store');
     Route::get('/share/file/delete/{id}',[ShareController::class,'destroy'])->name('share.file.delete');
     Route::get('/admin/file/recieve/',[RecievedController::class,'index'])->name('recieve.file.admin');
     Route::get('/admin/file/share/',[ShareController::class,'index'])->name('share.file.admin');
     /*Request file / Request Recieve / Request File share*/
     Route::get('/admin/file/request/',[RequestController::class,'request'])->name('request.file.admin');
     Route::post('/admin/store/request/',[RequestController::class,'store'])->name('request.store.admin');
     Route::get('/admin/recieve/request/',[RequestController::class,'recieve'])->name('request.recieve.admin');
     Route::post('/request/file/recieve/',[RecievedController::class,'request_file_store'])->name('request.file.store');
     /*Resent file*/
     Route::get('/resent/file',[FileController::class,'resent'])->name('resent.file');
     /*change user Status on Share file*/
     Route::get('/file/share/user_type',[ShareController::class,'user_type'])->name('change.user_type');
        
      /*Dashboard route*/
      Route::get('/',[AdminController::class,'dashboard']);
      Route::get('/admin/dashboard',[AdminController::class,'dashboard'])->name('admin.dashboard');

      /*user route*/
      Route::post('/login',[AdminController::class,'store'])->name('user_store');
      Route::get('/admin/register',[AdminController::class,'register'])->name('register');
      Route::get('/logout',[AdminController::class,'logout'])->name('logout');
      Route::get('/users',[AdminController::class,'users'])->name('users.list');

      /*User block unblock*/
      Route::get('/user/block/{id}',[AdminController::class,'block'])->name('block.user');
      Route::get('/user/unblock/{id}',[AdminController::class,'unblock'])->name('unblock.user');

      /*User Delete Restore*/
      Route::get('/user/delete/{id}',[AdminController::class,'delete'])->name('delete.user');
      Route::get('/user/restore/{id}',[AdminController::class,'restore'])->name('restore.user');
       
 });

/*For testing Data*/
Route::get('/test',[FileController::class,'test'])->name('test');
