@extends('admin.layouts.layout')
@section('contant')
  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Recieved File</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item active">Recived File</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
   
<div class="container">
<div class="row">
        <div class="col-lg-12">
          <div class="card recent-sales overflow-auto">
                <div class="card-body" style="overflow-x:auto;">
                  <h5 class="card-title">Recent<span>| Activities</span></h5>
                  <table class="table table-borderless datatable">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Recent File</th>
                        <th scope="col">Preview</th>
                        <th scope="col">Size</th>
                        <th scope="col">Last Modifier</th>
                        <th scope="col">Access Status</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                    
                      @foreach($recieveds as $file)
                      <tr>
                        <th scope="row"><a href="#"><i class="fa fa-file-o"></i></a></th>
                        <td>{!! Str::limit($file->files->title, 20) !!}</td>
                        <td>
                         
                         @if($file->files->file_type=="image")
                          <img width="50px" height="50px" src="{{ Storage::disk('s3')->temporaryUrl($file->files->image??null, '+2 minutes') }}">
                         @elseif($file->files->file_type=="video")
                        <video width="100" height="100" controls>
                         <source src="{{ Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes') }}" >
                         </video>
                          @else
                          <iframe width="100px" height="100px" src="{{ Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes') }}"></iframe>
                          @endif
                        </td>
                        <td><a href="#" class="text-primary">{{$file->files->size}}</a></td>
                        <td>{{$file->updated_at}}</td>
                        <td>
                            @if($file->user_type=="1")
                        
                          <p>admin</p>
                          @elseif($file->user_type=="2")
                             <p>Editor</p>
                          @else
                              <p>viewer</p>

                          @endif
                        </td>

                        <td> 
                          
                        <div class="col-lg-4" style="margin-top: 10px;">
                         <a type="button" href="{{route('share.file.delete',$file->id)}}" class="btn btn-danger">Delete</a>
                          </div>
                           
                      </td>
                  </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
        </div>
      </div>
</div>
       </main><!-- End #main -->

@endsection