<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\File;
use App\Models\Recieved;
use Illuminate\Support\Facades\Auth;


class ViewerController extends Controller
{
    public function dashboard(){
      $id=auth()->user()->id;
      $files=File::where('user_id',$id)->get();
       $i_total=0;$d_total=0;$f_total=0;
            $i_size=0;$d_size=0;$f_size=0;
            foreach ($files as $file) {
            $bytes=$file->byte_size;
            if($file->file_type=="image"||$file->file_type=="video"){
              $i_total +=$bytes;
            }elseif($file->file_type=="document"){
              $d_total +=$bytes;
            }else{
              $f_total +=$bytes;
            }
            
          }

            $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $i_total > 1024; $i++) {
            $i_total /= 1024;
            }
          $i_size= round($i_total, 2) . ' ' . $units[$i];
          
          $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $d_total > 1024; $i++) {
            $d_total /= 1024;
            }
          $d_size= round($d_total, 2) . ' ' . $units[$i];

          $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $f_total > 1024; $i++) {
            $f_total /= 1024;
            }
          $f_size= round($f_total, 2) . ' ' . $units[$i];

      return view('viewer.dashboard',compact('files','i_size','d_size','f_size'));
    }

    public function recieved_file()
    {
        $id=auth()->user()->id;
        $recieveds=Recieved::Where('recieve_user_id',$id)->get();
        return view('viewer.share.recieved',compact('recieveds'));
    }
}
