<?php

namespace App\Http\Controllers;

use App\Models\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Response as Download; 


class FileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function resent()
    {
        if(auth()->user()->role=="1"){
         $files=File::orderby('id','desc')->get();   
        }else{
          $files=File::where('user_id',auth()->user()->id)->orderby('id','desc')->get();   
        }
        
        return view('admin.resent',compact('files'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // $messages = [
        //     'required' => 'Please select file to upload',
        // ];
  
        // $this->validate($request, [
        //     'images' => 'required',
        // ], $messages);

             $file=$request->images;
            $user_id=auth()->user()->id;
              

            
            $original_name=$file->getClientOriginalName();
            $filename = $user_id.'_'.$original_name;
            $e=$file->getClientOriginalExtension();
            $filesize = $file->getSize();
            $location=$file->storeAs('file-sharing',$filename,'s3');
            $units = ['Byte', 'KB', 'MB','GB'];
            $bytes=$filesize;
            for ($i = 0; $bytes > 1024; $i++) {
            $bytes /= 1024;
            }
            $size= round($bytes, 2) . ' ' . $units[$i];
        if($e=='jpg'||$e=='jpeg'||$e=='png'||$e=='webp'||$e=='gif'||$e=='tiff'||$e=='psd'||$e=='esp'||$e=='ai'){
            $file_type='image';
        }elseif($e=='mp4'||$e=='mov'||$e=='wmv'||$e=='avi'||$e=='avchd'||$e=='flv'||$e=='f4v'||$e=='swf'||$e=='mkv'||$e=='webm'||$e=='mpeg-2' ){
            $file_type='video';
        }elseif($e=='pdf'||$e=='docx'||$e=='doc'){
            $file_type='document';
        }else{
            $file_type='file';
        }


            $fileModel = new File;
            $fileModel->user_id=$user_id;
            $fileModel->extension=$e;
            $fileModel->file_type=$file_type;
            $fileModel->title = $original_name;
            $fileModel->size = $size;
            $fileModel->byte_size = $filesize;
            $fileModel->image = $location;
            $fileModel->save();

    

       return response()->json(['status' => 200,  'message' => 'File/s Uploaded Successfully']);

            // return redirect()->back()->with([
            //     'success'=> "File/s uploaded successfully",
            // ]);
        }
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\File  $file
     * @return \Illuminate\Http\Response
     */
    public function show(File $file)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\File  $file
     * @return \Illuminate\Http\Response
     */
    public function edit(File $file)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\File  $file
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, File $file)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\File  $file
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,File $file)
    {
        $id=$request->id;
        $file=File::find($id);
        Storage::disk('s3')->delete($file->image);
        $file->delete();
        return redirect()->back();
    }
    
    public function download(Request $request)
    {
      $id=$request->id;
      $file=File::find($id);
      $headers = [
            'Content-Type'        => 'Content-Type: application/'.$file->extension,
            'Content-Disposition' => 'attachment; filename="'. $file->image .'"',
        ];

        return Download::make(Storage::disk('s3')->get($file->image), 200, $headers);
    }
   
   public function test(){
        return view('test');
    }
}
