<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChatsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chats', function (Blueprint $table) {
           $table->id();
           $table->bigInteger('sender_user_id')->unsigned()->nullable();
           $table->foreign('sender_user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
           $table->bigInteger('reciever_user_id')->unsigned()->nullable();
           $table->foreign('reciever_user_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
           $table->bigInteger('parent_id')->unsigned()->nullable();
           $table->foreign('parent_id')->references('id')->on('chats')->onUpdate('cascade')->onDelete('cascade');
            $table->string('comment');
            $table->string('file');
            
            $table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('updated_at')->default(DB::raw('CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chats');
    }
}
