<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\File;
use App\Models\FileRequest;

class RequestController extends Controller
{
     public function request()
    {
        $users=User::where('company_id',auth()->user()->company_id)->get();
        return view('admin.request.request',compact('users'));
    }
    public function store(Request $request)
    {
        $validated = $request->validate([
        'title' => 'required|max:255',
        'message' => 'required|max:500',
        'user' => 'required',
    ]);
        $input = $request->all();
        $users = $input['user'];
        $length=count($users);
       
        for($i=0;$i<$length;$i++){
            $data=array(
             'title'=>$request->title,
             'message'=>$request->message,
             'request_userId'=>auth()->user()->id,
             'user_id'=>$input['user'][$i],
            );
          FileRequest::create($data);  
        }
        
        
        return redirect()->back();
      
    }
    public function recieve(){
        $files=File::where('user_id',auth()->user()->id)->where('company_id',auth()->user()->company_id)->get();
        $files_name=FileRequest::where('user_id',auth()->user()->id)->orderby('id','desc')->get();
        return view('admin.request.recieve_request',compact('files_name','files'));
    }
}
