<?php

namespace App\Http\Controllers;

use App\Models\Folder;
use App\Models\User;
use Illuminate\Http\Request;

class FolderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function files(Request $request)
    {
        $folderId=$request->id;
        $folderName=Folder::where('id',$folderId)->first();
        $allFolders=Folder::where('parent_id',$folderId)->get();
        $folder=Folder::with('files')
                ->whereHas('files', function ($query) use($folderId){
                $query->where('user_id',auth()->user()->id)->where('folder_id',$folderId);
                })->get();
        return view('admin.folder.files',compact('allFolders','folder','folderName'));   
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if(auth()->user()->role=="0"){
         $folders=Folder::where('parent_id',Null)->get(); 
        }
       elseif(auth()->user()->role=="1"){
         $folders=Folder::where('parent_id',Null)->where('company_id',auth()->user()->company_id)->get(); 
        }else{
         $folders=Folder::where('user_id',auth()->user()->id)->where('parent_id',Null)->get();   
        }
        $users=User::where('id','!=',auth()->user()->id)->where('company_id',auth()->user()->company_id)->get(); 
        return view('admin.folder.folder',compact('folders','users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $data=array(
        'name'=>$request->name,
        'user_id'=>auth()->user()->id,
        'parent_id'=>$request->parent_id,
        'company_id'=>auth()->user()->company_id,
       );
       $folder=Folder::create($data);
       return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Folder  $folder
     * @return \Illuminate\Http\Response
     */
    public function show(Folder $folder)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Folder  $folder
     * @return \Illuminate\Http\Response
     */
    public function edit(Folder $folder)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Folder  $folder
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Folder $folder)
    {
        $id=$request->folder_id;
        $folder=Folder::where('id',$id)->first();
        $folder->update([
         'name'=>$request->name,
        ]);
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Folder  $folder
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Folder $folder)
    {
        $id=$request->folderId;
        $folder=Folder::where('id',$id)->first();
        $folder->delete();
        return response()->json(['success' => 'Folder is deleted successfully.']);
    }
}
