<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\File;
use App\Models\Role;
use App\Models\Company;
use App\Events\UserRegister;
use Illuminate\Support\Facades\Auth;
use DB;

class AdminController extends Controller
{
    public function dashboard(){
      $role=auth()->user()->role;
      if($role=="1"){
       $files=File::where('company_id',auth()->user()->company_id)->get(); 
     }elseif($role=="2"){
      $files=File::where('user_id',auth()->user()->id)->get(); 
     }elseif($role=="3"){
      $files=File::where('user_id',auth()->user()->id)->get(); 
     }else{
       $files=File::get();
     }
      
    

            $i_total=0;$d_total=0;$f_total=0;
            $i_size=0;$d_size=0;$f_size=0;
            foreach ($files as $file) {
            $bytes=$file->byte_size;
            if($file->file_type=="image"||$file->file_type=="video"){
              $i_total +=$bytes;
            }elseif($file->file_type=="document"){
              $d_total +=$bytes;
            }else{
              $f_total +=$bytes;
            }
            
          }

            $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $i_total > 1024; $i++) {
            $i_total /= 1024;
            }
          $i_size= round($i_total, 2) . ' ' . $units[$i];
          
          $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $d_total > 1024; $i++) {
            $d_total /= 1024;
            }
          $d_size= round($d_total, 2) . ' ' . $units[$i];

          $units = ['Byte', 'KB', 'MB','GB'];
           for ($i = 0; $f_total > 1024; $i++) {
            $f_total /= 1024;
            }
          $f_size= round($f_total, 2) . ' ' . $units[$i];


          if($role=="1"){
          $images=File::where('company_id',auth()->user()->company_id)->where(function($query) {
        $query->where('file_type', 'image');
        $query->orWhere('file_type', 'video');
        })->count();
          $doc=File::where('file_type','document')->where('company_id',auth()->user()->company_id)->count();
          $total_file=File::where('file_type','file')->where('company_id',auth()->user()->company_id)->count();
          }elseif($role=="2" || $role=="3"){
             $images=File::where('user_id',auth()->user()->id)
          ->where(function($query) {
        $query->where('file_type', 'image');
        $query->orWhere('file_type', 'video');
        })->count();
          $doc=File::where('user_id',auth()->user()->id)->where('file_type','document')->count();
          $total_file=File::where('user_id',auth()->user()->id)->where('file_type','file')->where('company_id',auth()->user()->company_id)->count();
          }else{
              $images=File::where(function($query) {
        $query->where('file_type', 'image');
        $query->orWhere('file_type', 'video');
        })->count();
          $doc=File::where('file_type','document')->count();
          $total_file=File::where('file_type','file')->count();
          }
      

        
      $users=User::where('id', '!=', auth()->id())->where('company_id',auth()->user()->company_id)->get();
      return view('admin.dashboard',compact('files','users','i_size','d_size','f_size','images','doc','total_file'));
    }

    public function profile(){
        
      return view('admin.user.profile');
    }
    public function users(){
      if(auth()->user()->role == "0"){
        $users=User::where('id',"!=",auth()->user()->id)->withTrashed()->paginate(10);
      }else{
        $users=User::where('id',"!=",auth()->user()->id)->where('company_id',auth()->user()->company_id)->withTrashed()->paginate(10);
      }
       
        return view('admin.user.list',compact('users'))->with('i', (request()->input('page', 1) - 1) * 10);
      return view('admin.user.list');
    }
    public function login(){

      return view('admin.user.login');
    }
     public function register(){
      $roles=Role::where('role','!=',0)->get();
      $companies=Company::get();
      return view('admin.user.register',compact('roles','companies'));
    }
    public function store(Request $request ){

      $errorMsgs=[
      'email.unique'=>'This email is already taken',
      'password.confirmed'=>'Re-match password',
    ];   
       $validator= $request->validate([
            'email'=>'required|email|unique:users,email',
            'password' => 'required|confirmed|min:6',
            'name' => 'required',
            'role' => 'required',
            'department' => 'required',
            
        ],$errorMsgs); 
         
       $data=array(
         'name'=>$request->name,
         'email'=>$request->email,
         'password'=>Hash::make($request->password),
         'pass_user'=>$request->password,
         'role'=>$request->role,
         'department'=>$request->department,
         'company_id'=>auth()->user()->company_id
       );

       $user=User::create($data);
       event(new UserRegister($data));
        return redirect()->route('register')
        ->with('success','New User Added successfully.'); 
    }

    public function makeLogin(Request $request){
    $data=array(
    'email'=>$request->email,
    'password'=>$request->password,
    );
    // if(Auth::attempt($data, $request->get('remember'))){
    if(Auth::attempt($data)){
         return redirect()->route('admin.dashboard');
       
    }else{
        return back()->withErrors(['message'=>'invalid email or password']);
    }
}
public function user_update(Request $request ){
         
       $validator= $request->validate([
            'name' => 'required',
            'department' => 'required',
         ]); 

       $data=array(
         'name'=>$request->name,
         'department'=>$request->department,
        
       );
       $user=User::where('id',auth()->user()->id)->first();
      $user->update($data);
        return back(); 
    }

    public function logout(){
    Auth::logout();
    return redirect()->route('login');
  }  
  public function block(Request $request){
    $id=$request->id;
    $block=DB::table('users')
            ->where('id', $id)
            ->update(['blocked_at' => Now()]);
    return redirect()->route('users.list')
                        ->with('success','User Blocked Successfully.');
  } 
  
  public function unblock(Request $request){
    $id=$request->id;
    $block=DB::table('users')
            ->where('id', $id)
            ->update(['blocked_at' => null]);
    return redirect()->route('users.list')
                        ->with('success','User Unblocked Successfully.');
  } 
  public function delete(Request $request){
    $id=$request->id;
    $User=User::where('id', $id)->first()->delete();
    return redirect()->route('users.list')
                        ->with('success','User Deleted Successfully.');
  } 
  public function restore(Request $request){
  
    $id=$request->id;
    $User=User::withTrashed()->where('id', $id)->restore();
    return redirect()->route('users.list')
                        ->with('success','User Restored Successfully.');
  }   
}
