<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BaseController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\RecievedController;
use App\Http\Controllers\ShareController;
use App\Http\Controllers\RequestController;
use App\Http\Controllers\FolderController;
use App\Http\Controllers\SharefolderController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\CompanyController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });


Route::get('/login',[AdminController::class,'login'])->name('login');
Route::post('/user/login',[AdminController::class,'makeLogin'])->name('makeLogin');



/*Auth and Active_User Middleware Route*/
Route::group(['middleware'=>['auth', 'active_user']],function(){

     /*chat route*/
     Route::get('/chat',[ChatController::class,'create'])->name('chat');
     Route::get('/chat/user/{id}',[ChatController::class,'user_chat'])->name('user.chat');
     Route::post('/chat/file/store',[ChatController::class,'file_stor'])->name('chat.file.store');
     Route::post('/chat/file/upload',[ChatController::class,'file_upload'])->name('upload.file.chat');

     /*Groups For Chat*/
      Route::post('/groups',[GroupController::class,'store'])->name('group.store');
      Route::get('/chat/groups',[GroupController::class,'group_chat'])->name('group.chat');

     /*Profile route*/
     Route::get('/profile',[AdminController::class,'profile'])->name('profile');

     /*File route*/
     Route::post('/file/upload',[FileController::class,'store'])->name('upload.file');
     Route::get('/file/delete',[FileController::class,'destroy'])->name('delete.file');
     Route::get('/file/download/{id}',[FileController::class,'download'])->name('download.file');

     /*share and recieve route*/
     Route::post('/file/share/',[FileController::class,'share'])->name('share.file');
     Route::post('/file/recieve/',[RecievedController::class,'store'])->name('recieve.file.store');
     Route::get('/share/file/delete',[ShareController::class,'destroy'])->name('share.file.delete');
     Route::get('/admin/file/recieve/',[RecievedController::class,'index'])->name('recieve.file.admin');
     Route::get('/admin/file/share/',[ShareController::class,'index'])->name('share.file.admin');
     /*Request file / Request Recieve / Request File share*/
     Route::get('/admin/file/request/',[RequestController::class,'request'])->name('request.file.admin');
     Route::post('/admin/store/request/',[RequestController::class,'store'])->name('request.store.admin');
     Route::get('/admin/recieve/request/',[RequestController::class,'recieve'])->name('request.recieve.admin');
     Route::post('/request/file/recieve/',[RecievedController::class,'request_file_store'])->name('request.file.store');
     Route::post('/request/file/recieve/device',[RecievedController::class,'request_file_store_device'])->name('request.file.store.device');
     /*Resent file*/
     Route::get('/resent/file',[FileController::class,'resent'])->name('resent.file');
     /*change user Status on Share file*/
     Route::get('/file/share/user_type',[ShareController::class,'user_type'])->name('change.user_type');
        

      /*Create Folder*/
     Route::get('/folder',[FolderController::class,'create'])->name('folders');
     Route::post('/folder',[FolderController::class,'store'])->name('folder.store');
     Route::get('/folder/files/{id}',[FolderController::class,'files'])->name('folder.files');
     Route::get('/folder/delete',[FolderController::class,'destroy'])->name('folder.delete');
     Route::post('/folder/update',[FolderController::class,'update'])->name('folder.update');
     /*Share Folder*/
     Route::post('/folder/share',[SharefolderController::class,'share'])->name('share.folder');
     Route::get('/folder/recieve',[SharefolderController::class,'recieve'])->name('recieve.folder');
     Route::get('/folder/recieve/delete',[SharefolderController::class,'destroy'])->name('recieve.folder.delete');

     /*File Upload in Folder*/
     Route::post('/folder/file/upload',[FileController::class,'folder_file_store'])->name('upload.folder.file');

      

      /*Dashboard route*/
      Route::get('/',[AdminController::class,'dashboard']);
      Route::get('/admin/dashboard',[AdminController::class,'dashboard'])->name('admin.dashboard');
      
      /*company route*/
      Route::get('/company/create',[CompanyController::class,'create'])->name('company.create');
      Route::post('/company/store',[CompanyController::class,'store'])->name('company.store');
      Route::get('/company/list',[CompanyController::class,'index'])->name('company.list');


      /*user route*/
      Route::post('/login',[AdminController::class,'store'])->name('user_store');
      Route::get('/admin/register',[AdminController::class,'register'])->name('register');
      Route::get('/logout',[AdminController::class,'logout'])->name('logout');
      Route::get('/users',[AdminController::class,'users'])->name('users.list');
      Route::post('/users/update',[AdminController::class,'user_update'])->name('update.profile');

      /*User block unblock*/
      Route::get('/user/block/{id}',[AdminController::class,'block'])->name('block.user');
      Route::get('/user/unblock/{id}',[AdminController::class,'unblock'])->name('unblock.user');

      /*User Delete Restore*/
      Route::get('/user/delete/{id}',[AdminController::class,'delete'])->name('delete.user');
      Route::get('/user/restore/{id}',[AdminController::class,'restore'])->name('restore.user');
       
 });

/*For testing Data*/
Route::get('/test',[FileController::class,'test'])->name('test');
