@extends('admin.layouts.layout')
@section('contant')
  <main id="main" class="main">
<div class="container-fluid pt-4 px-4">
<div class="row g-4">


                    <div class="col-12">
                        <div class="bg-light rounded h-100 p-4">
                            <h4 class="mb-4">Users</h4>
                            <div class="pull-right">
                <a class="btn btn-success" href="{{route('register')}}"> Add New User</a>
            </div>
                            @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col"> Name</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Role</th>
                                            <th scope="col">Department</th>
                                            <th scope="col">Block User</th>
                                            <th scope="col">Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($users as $user)
                                        <tr>
                                            <th scope="row">{{++$i}}</th>
                                            <td>{{$user->name}}</td>
                                            <td>{{$user->email}}</td>
                                            <td>@if ($user->role == 1)
        
        <div  class="btn btn-success">admin</div>
@elseif ($user->role == 2)
       <div  class="btn btn-warning">Editor</div>
        @else
        <div class="btn btn-info">Viewer</div>

@endif </td>
                                            <td>{{$user->department}}</td>

                                            @if($user->blocked_at == null )
                                            <td><a href="{{route('block.user',$user->id)}}" class="btn btn-info">Block</a></td>
                                            @elseif($user->blocked_at)
                                            <td><a href="{{route('unblock.user',$user->id)}}" class="btn btn-danger">Unblock</a></td>
                                            @endif
                                            @if($user->deleted_at == null )
                                            <td><a href="{{route('delete.user',$user->id)}}" class="btn btn-danger">Delete</a></td>
                                            @elseif($user->deleted_at)
                                            <td><a href="{{route('restore.user',$user->id)}}" class="btn btn-info">Restore</a></td>
                                            @endif
                                        </tr>
                                       @endforeach
                                    </tbody>
                                </table>
                                {{ $users->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
     </div>
 </div>
</main>
@endsection

