@extends('admin.layouts.layout')
@section('contant')
  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Shared File List</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item active">Shared File</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
   
<div class="container">
<div class="row">
        <div class="col-lg-12">
          <div class="card recent-sales overflow-auto">
                <div class="card-body" style="overflow-x:auto;">
                  <h5 class="card-title">Recent<span>| Activities</span></h5>
                  <table class="table table-borderless datatable">
                     @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Recent File</th>
                        <th scope="col">Preview</th>
                        <th scope="col">Size</th>
                        <th scope="col">Last Modifier</th>
                        <th scope="col">Change User Access</th>
                        <th scope="col">User Name</th>
                        <th scope="col">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                    
                      @foreach($recieveds as $file)
                      <tr>
                        <th scope="row">{{$loop->index+1}}</th>
                        <td>{!! Str::limit($file->files->title, 20) !!}</td>
                        <td>
                         
                         @if($file->files->file_type=="image")
                          <img width="50px" height="50px" src="{{ Storage::disk('s3')->temporaryUrl($file->files->image??null, '+2 minutes') }}">
                         @elseif($file->files->file_type=="video")
                        <video width="50" height="50" controls>
                         <source src="{{ Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes') }}" >
                         </video>
                          @else
                          <iframe width="100px" height="100px" src="{{ Storage::disk('s3')->temporaryUrl($file->files->image, '+2 minutes') }}"></iframe>
                          @endif
                        </td>
                        <td><a href="#" class="text-primary">{{$file->files->size}}</a></td>
                        <td>{{$file->updated_at}}</td>
                        <td>
                          @php $type=$file->user_type @endphp
                          <select class="user_type" data-id="{{$file->id}}">
                            <option value="1" @if($type=="1") selected @endif>Admin</option> 
                            <option value="2" @if($type=="2") selected @endif>Editor</option>
                            <option value="3" @if($type=="3") selected @endif>Viewer</option>
                          </select>
                        </td>
                        <td>
                          {{$file->users->name}}
                        </td>
                        

                        <td> 
                           
                        <div class="col-lg-4" style="margin-top: 10px;">
                         <button  class="btn btn-danger btn-delete" data-id="{{ $file->id }}"><i class="bi bi-trash"></i></button>
                          </div>
                          
                      </td>
                  </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
        </div>
      </div>
</div>
       </main><!-- End #main -->

@endsection

@push('footer-script')  
<script>

$('.user_type').on('change',function(){
  var user_type=$(this).val();
  var id=$(this).data('id');
  $.ajax({
  url:'{{route("change.user_type")}}',
  data:{
    'user_type':user_type,
    'id':id,
  }
  });
});  
$('.btn-delete').click(function() {
    var fileId = $(this).data('id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.value) {
            $.ajax({
              type: 'get',              
              url: '{{ route('share.file.delete') }}?fileId='+fileId,
                
                
                success: function(data) {
                    Swal.fire(
                        'Deleted!',
                        'Your record has been deleted.',
                        'success'
                    );
                   setTimeout(function () {
        
        location.reload(true);
      }, 1000);
      
   
                }
            });
        }
    });
});

</script>
@endpush


