@extends('admin.layouts.layout')
@section('contant')
  <main id="main" class="main">
<div class="container-fluid pt-4 px-4">
<div class="row g-4">


                    <div class="col-12">
                        <div class="bg-light rounded h-100 p-4">
                            <h4 class="mb-4">Users</h4>
                            <div class="pull-right">
                <a class="btn btn-success" href="{{route('company.create')}}"> Add New Company</a>
            </div>
                            @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
        @endif
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col"> Name</th>
                                            <th scope="col">Logo</th>
                                            <th scope="col">Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($companies as $company)
                                        <tr>
                                            <th scope="row">{{++$i}}</th>
                                            <td>{{$company->companyName}}</td>
                                            <td><img src="{{asset('storage/companies/'.$company->logo)}}" width="100" height="50"></td>
                                            <td><button class="btn btn-danger"><i class="bi bi-trash"></i></button></td>
                                        </tr>   
                                       @endforeach
                                    </tbody>
                                </table>
                                {{ $companies->links('pagination::bootstrap-4') }}
                            </div>
                        </div>
     </div>
 </div>
</main>
@endsection

