 @extends('admin.layouts.layout')
@section('contant')

  <main id="main" class="main">
  
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-10 col-md-12 d-flex flex-column align-items-center justify-content-center" style="width: 100%">
              <div class="card mb-8">
                <div class="card-body">
                  <div class="pt-4 pb-2">
                    <h5 class="card-title text-center pb-0 fs-4">Create Company</h5>
                  </div>
                  <div class="card-body">
                     @if ($message = Session::get('success'))
                     <div class="alert alert-success">
                     <p>{{ $message }}</p>
                     </div>
                     @endif
                  <form class="row g-3 " action="{{route('company.store')}}" method="post" novalidate enctype="multipart/form-data">
                    @csrf
                    <div class="col-12">
                      <label for="yourName" class="form-label">Company Name</label>
                      <input type="text" name="companyName" class="form-control" value="{{old('companyName')}}" required>
                      <div class="invalid-feedback">Please, enter your company name</div>
                      @if ($errors->has('companyName'))
                    <span class="text-danger">{{ $errors->first('companyName') }}</span>
                     @endif
                    </div>
                    <div class="col-12">
                      <label  class="form-label">Company Logo</label>
                      <input type="file" name="logo" class="form-control" >
                      @if ($errors->has('logo'))
                    <span class="text-danger">{{ $errors->first('logo') }}</span>
                     @endif
                    </div>
                   
                   <div class="col-12">
                      <label for="yourEmail" class="form-label">Company Address</label>
                      <textarea name="address" class="form-control"  required>{{old('address')}}</textarea>
                      <div class="invalid-feedback">Please enter the aompany adddress</div>
                      @if ($errors->has('address'))
                    <span class="text-danger">{{ $errors->first('address') }}</span>
                     @endif
                    </div>
                    <div class="col-12">
                      <label for="yourName" class="form-label">Full Name</label>
                      <input type="text" name="name" class="form-control" id="yourName" required>
                      <div class="invalid-feedback">Please, enter your name!</div>
                      @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
                    </div>
                    <div class="col-12">
                      <label for="yourEmail" class="form-label">Company Admin Email</label>
                      <input type="email" name="email" class="form-control" id="yourEmail" required>
                      <div class="invalid-feedback">Please enter a valid Email adddress!</div>
                      @if ($errors->has('email'))
                    <span class="text-danger">{{ $errors->first('email') }}</span>
                @endif
                    </div>
                    <div class="col-12">
                  <div class="dropdown">
                      <label for="Department" class="form-label">Department</label>
                    <select name="department" class="form-control" aria-label="Default select example">
                      <option selected disabled>Department</option>
                      <option value="Mobile Application">Mobile Application</option>
                      <option value="Web Development">Web Development</option>
                      <option value="Graphic Designing">Graphic Designing</option>
                      <option value="Vide Editor">Vide Editor</option>
                      <option value="SEO">SEO</option>
                      <option value="Marketing">Marketing</option>
                    </select>
                  </div>
                  @if ($errors->has('department'))
                    <span class="text-danger">{{ $errors->first('department') }}</span>
                @endif
                </div>
                    <div class="col-12">
                      <label for="yourPassword" class="form-label">Password</label>
                      <input id="password-field" type="password" class="form-control password-field" name="password" placeholder="Password">
                      
                    </div>
                    @if ($errors->has('password'))
                 <span class="text-danger">{{ $errors->first('password') }}</span>
                 @endif
                    <div class="col-12">
                      <label for="yourPassword" class="form-label">Re-Enter Password</label>
                      <input id="password-field" type="password" class="form-control password-field" name="password_confirmation" placeholder="Password">
                      
                      @if ($errors->has('password'))
                 <span class="text-danger">{{ $errors->first('password') }}</span>
                 @endif
                    </div>
                    <span>Show password <input type='checkbox' id='check' /></span>
                   <div class="col-12 mt-3">
                      <button class="btn btn-primary w-100" type="submit">Add Company</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- Default dropend button -->


 </main><!-- End #main -->
 <script type='text/javascript'>
        $(document).ready(function(){
            $('#check').click(function(){
             
                $(this).is(':checked') ? $('.password-field').attr('type', 'text') : $('.password-field').attr('type', 'password');
            });
        });
    </script>
@endsection