<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Auth;
use App\Models\File;
class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        /* define a master admin user role */
        Gate::define('isMasterAdmin', function($user) {
           return $user->role == '0';
        });
        
        /* define a admin user role */
        Gate::define('isAdmin', function($user) {

           return $user->role == '1';
        });
       
        /* define a manager user role */
        Gate::define('isEditor', function($user) {
            return $user->role == '2';
        });
      
        /* define a user role */
        Gate::define('isUser', function($user) {
            return $user->role == '3';
        });
        Gate::define('isAuthor', function($user,$file) {
            
            return auth()->user()->id == $file->user_id;
            
        });
    }
}
