<?php

namespace App\Http\Controllers;

use App\Models\Sharefolder;
use Illuminate\Http\Request;

class SharefolderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function recieve()
    {
        $sharefolder=Sharefolder::with('folders')->where('recieve_user_id',auth()->user()->id)->get();
        return view('admin.folder.recievefolder',compact('sharefolder'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function share(Request $request)
    {
        $users=$request->shared;
        foreach($users as $user){
            $data=array(
             'share_user_id'=>auth()->user()->id,
             'recieve_user_id'=>$user,
             'folder_id'=>$request->folder_id,
             'user_type'=>$request->user_type,
            );
            $share=Sharefolder::create($data);
        }
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Sharefolder  $sharefolder
     * @return \Illuminate\Http\Response
     */
    public function show(Sharefolder $sharefolder)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Sharefolder  $sharefolder
     * @return \Illuminate\Http\Response
     */
    public function edit(Sharefolder $sharefolder)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Sharefolder  $sharefolder
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Sharefolder $sharefolder)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Sharefolder  $sharefolder
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Sharefolder $sharefolder)
    {
        $id=$request->folderId;
        $shareFolder=Sharefolder::where('id',$id)->first();
        $shareFolder->delete();
        return response()->json(['success' => 'Folder is deleted successfully.']);
        
    }
}
