<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\User;
use Illuminate\Http\Request;
use App\Events\UserRegister;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;


class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $companies=Company::paginate(10);
    return view('admin.company.list',compact('companies'))->with('i', (request()->input('page', 1) - 1) * 10);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
     return view('admin.company.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $errorMsgs=[
      'email.unique'=>'This email is already taken',
      'password.confirmed'=>'Re-match password',
    ]; 
        $request->validate([
            'companyName' => 'required',
            'logo' => 'required|image',
            'address' => 'required',
            'email'=>'required|email|unique:users,email',
            'password' => 'required|confirmed|min:6',
            'name' => 'required',
            'department'=>'required'
        ],$errorMsgs);

       
        $data=array(
         'companyName'=>$request->companyName,
         'address'=>$request->address,
        );


             if($request->hasFile('logo')){
                $destination_path='public/companies';
                $logo=$request->file('logo');
                $image_name=md5(rand(1000,100000));
                $ext=strtolower($logo->getClientOriginalExtension());
                $image_full_name=$image_name.'.'.$ext;
                $path=$request->file('logo')->storeAs($destination_path,$image_full_name);
                $data['logo']=$image_full_name;
             }
        $company=Company::create($data);

        $data=array(
         'name'=>$request->name,
         'email'=>$request->email,
         'password'=>Hash::make($request->password),
         'pass_user'=>$request->password,
         'role'=>1,
         'department'=>$request->department,
         'company_id'=>$company->id,
       );
        $user=User::create($data);
       event(new UserRegister($data));
        return redirect()->route('company.create')
                        ->with('success','Company is Created successfully'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function show(Company $company)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function edit(Company $company)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Company $company)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function destroy(Company $company)
    {
        //
    }
}
