 @extends('admin.layouts.layout')
@section('contant')

  <main id="main" class="main">
    
        <div class="container">
          <div class="row justify-content-center">
            <div class="col-lg-10 col-md-12 d-flex flex-column align-items-center justify-content-center" style="width: 100%">
              <div class="card mb-8">
                <div class="card-body">
                  <div class="pt-4 pb-2">
                    <h5 class="card-title text-center pb-0 fs-4">Create User</h5>
                  </div>
                  <div class="card-body">
                     @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
                  <form class="row g-3 " action="{{route('user_store')}}" method="post" novalidate>
                    @csrf
                    <div class="col-12">
                      <label for="yourName" class="form-label">First Name and Last Name</label>
                      <input type="text" name="name" class="form-control" id="yourName" required>
                      <div class="invalid-feedback">Please, enter your name!</div>
                      @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
                    </div>
                    <div class="col-12">
                      <label for="yourEmail" class="form-label">User Email</label>
                      <input type="email" name="email" class="form-control" id="yourEmail" required>
                      <div class="invalid-feedback">Please enter a valid Email adddress!</div>
                      @if ($errors->has('email'))
                    <span class="text-danger">{{ $errors->first('email') }}</span>
                @endif
                    </div>
                 
                    <div class="col-12">
                      <label for="yourPassword" class="form-label">Password</label>
                      <input id="password-field" type="password" class="form-control" name="password" placeholder="Password">
                      <span toggle="#password-field" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                    </div>
                    @if ($errors->has('password'))
                 <span class="text-danger">{{ $errors->first('password') }}</span>
                 @endif
                    <div class="col-12">
                      <label for="yourPassword" class="form-label">Re-Enter Password</label>
                      <input id="password-field" type="password" class="form-control" name="password_confirmation" placeholder="Password">
                      <span toggle="#password-field" class="fa fa-fw fa-eye field-icon toggle-password"></span>
                      @if ($errors->has('password'))
                 <span class="text-danger">{{ $errors->first('password') }}</span>
                 @endif
                    </div>
                    
                    <div class="col-12">
                  <div class="dropdown">
                      <label for="User" class="form-label">User Type</label>
                    <select class="form-control" name="role" aria-label="Default select example">
                      <option selected disabled>Access</option>
                      @foreach($roles as $role)
                      <option value="{{$role->role}}">{{$role->name}} Access</option>
                      @endforeach
                    </select>
                  </div>
                  @if ($errors->has('role'))
                    <span class="text-danger">{{ $errors->first('role') }}</span>
                @endif
                </div>
                
                <div class="col-12">
                  <div class="dropdown">
                      <label for="Department" class="form-label">Department</label>
                    <select name="department" class="form-control" aria-label="Default select example">
                      <option selected disabled>Department</option>
                      <option value="Mobile Application">Mobile Application</option>
                      <option value="Web Development">Web Development</option>
                      <option value="Graphic Designing">Graphic Designing</option>
                      <option value="Vide Editor">Vide Editor</option>
                      <option value="SEO">SEO</option>
                      <option value="Marketing">Marketing</option>
                    </select>
                  </div>
                  @if ($errors->has('department'))
                    <span class="text-danger">{{ $errors->first('department') }}</span>
                @endif
                </div>
                    <div class="col-12 mt-3">
                      <button class="btn btn-primary w-100" type="submit">Create Account</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
    


<script>
  $(".toggle-password").click(function() {

  $(this).toggleClass("fa-eye fa-eye-slash");
  var input = $($(this).attr("toggle"));
  if (input.attr("type") == "password") {
    input.attr("type", "text");
  } else {
    input.attr("type", "password");
  }
});
</script>





<script>
var modal = document.getElementById("myModal");
var btn = document.getElementById("myBtn");
var span = document.getElementsByClassName("close")[0];
btn.onclick = function() {
  modal.style.display = "block";
}
span.onclick = function() {
  modal.style.display = "none";
}
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}
</script>
 </main><!-- End #main -->
@endsection