@extends('admin.layouts.layout')
@section('contant')
  <main id="main" class="main">
    <div class="pagetitle">
      <h1>Requested Files List</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item active">Shared File</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
   
<div class="container">
<div class="row">

        <div class="col-lg-12">
          <div class="card recent-sales overflow-auto">
                <div class="card-body">
                  <h5 class="card-title">Recent<span>| Activities</span></h5>
                  <table class="table table-borderless datatable">
                   
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Name</th>
                        <th scope="col">Requested File</th>
                        <th scope="col">Message</th>
                        <th scope="col">Request Time</th>
                        <th scope="col">Status</th>
                        
                      </tr>
                    </thead>
                    <tbody>
                    
                      @foreach($files_name as $file)

                      <tr>
                        <th scope="row">{{$loop->index+1}}</th>
                        <td>{{$file->user->name}}</td>                        
                        <td><a href="#" class="text-primary">{{$file->title}}</a></td>
                        <td>{!! Str::limit($file->message, 20) !!}</td>
                        <td>{{$file->created_at->diffForHumans()}}</td>
                        @if($file->status =="complete")
                           <td><p>Shared</p></td>
                        @else
                        <td> 
                            <button class="btn btn-secondary" data-toggle="modal" data-target="#exampleModalCenter" id="share_file_device" data-id="{{$file->id}}">On Device</button>
                            <button id="share_file" data-id="{{$file->id}}" class="btn btn-primary" data-toggle="modal" data-target="#exampleModalCenter1">On WorkSpace</button>
                        </td>
                        @endif
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
        </div>
      </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">Select a File To Upload</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form  method="post" enctype="multipart/form-data" id="file-upload">
        @csrf
      <div class="modal-body">
      <input type="file" name="file">
      <input type="hidden" name="request_file" id="request_fil">
      </div>
      <div class="modal-footer">
       
        <button type="submit" class="btn btn-primary" ><span class="upload1" ></span>Upload & Share</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModalCenter1" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      
      <form action="{{route('request.file.store')}}" method="post">
        @csrf
      <div class="modal-body">
       <h4>select file to share</h4>
       <hr>
        <table class="table table-borderless ">
                   
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">File Name</th>
                        <th scope="col">Select File</th>
                      </tr>
                    </thead>
                    <tbody>
                    
                      @foreach($files as $file)
                      <tr>
                        <th scope="row">{{$loop->index+1}}</th>
                        <td>{{$file->title}}</td>                        
                        <td><input type="radio" class="fil_id" name="shared_file" value="{{$file->id}}"></td>    
                                     
                     @endforeach
                    </tbody>
                  </table>
                    <input type="hidden" name="request_file" id="request_file">
      </div>
      <div class="modal-footer">
        <button id="upload" type="submit" class="btn btn-primary">Share</button>
      </div>
    </form>
    </div>
  </div>
</div>
       </main><!-- End #main -->

@endsection

@push('footer-script')
<script>
     $(document).ready(function(){
     
  $("#share_file").click(function(){
     $("#upload").attr('disabled',true);
     var id=$(this).data('id');
        $("#request_file").val(id);
  });
  $(".fil_id").click(function(){
    $("#upload").attr('disabled',false);
  });
  $("#share_file_device").click(function(){
     
     var id=$(this).data('id');
        $("#request_fil").val(id);
  });
 
}); 

$(document).ready(function (e) {
$.ajaxSetup({
headers: {
'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
}
});
$('#file-upload').submit(function(e) {
e.preventDefault();
jQuery("button").attr("disabled", true);
$(".upload1").addClass("fa fa-circle-o-notch fa-spin");
var formData = new FormData(this);
$.ajax({
type:'POST',
url: "{{route('request.file.store.device')}}",
data: formData,
cache:false,
contentType: false,
processData: false,
 success: function(data) {
                    Swal.fire(
                        'Shared!',
                        'Your Upload & Shared Successfully.',
                        'success'
                    );
                   setTimeout(function () {
        
        location.reload(true);
      }, 1000);
      
   jQuery("button").attr("disabled", false);
                }
});
});
});

</script>
@endpush




