@extends('admin.layouts.layout')
@section('contant')

<main id="main" class="main">

  <div class="pagetitle row">
    <div class="col-md-6">
      <h1>Folders</h1>
    </div>
    

  </div><!-- End Page Title -->
  <div class="container m-0" >
   <div class="row">
    <div class="col-lg-12 ">
      <div class="card  overflow-auto row d-flex" style="flex-direction: row;">
        @foreach($sharefolder as $folder)
        <div   class="col-md-3 mt-2 mb-2"  style="color:#012970;">
         <div class="server-action-menu d-flex justify-content-between">
           <a href="{{route('folder.files',$folder->folders->id)}}" style="color:#012970;"><i class="fa fa-folder" aria-hidden="true"></i> {{ $folder->folders->name }}</a>
           <div class="dropdown">
            <a type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="bi bi-three-dots-vertical"></i></a>
              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                <li><button class="dropdown-item folder-delete" data-id="{{$folder->id}}">Delete</button></li>
                <li><button class="dropdown-item folder-share" data-toggle="modal" data-target="#exampleModalCenter1" data-id="{{$folder->folders->id}}" id="share-folder">Share</button></li>
                <li><button class="dropdown-item folder-edit" data-toggle="modal" data-target="#exampleModalCenter2" data-id="{{$folder->id}}" data-name="{{$folder->name}}">Rename</button></li>
              </ul>
            </div>

          </div>
        </div>            
        @endforeach
      </div>
    </div>
  </div>
</div>
</main>
<!-- Modal For Edit Folder Name-->
<div class="modal fade" id="exampleModalCenter2" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">Edit Name</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
       <form class="form-inline" action="{{route('folder.update')}}" method="post" >
        @csrf
        <label class="sr-only" for="inlineFormInputName2">Folder Name</label>
        <input type="text" name="name" class="form-control mb-2"  placeholder="Folder Name"  required id="folder_name">
        <input type="hidden" name="folder_id" id="folder_id">
        <button type="submit" class="btn btn-secondary mb-2">Update</button>
      </form>
    </div>

  </div>
</div>
</div>
@endsection

       @push('footer-script') 
<script type="text/javascript">
  $('.folder-delete').click(function() {
    var folderId = $(this).data('id');

    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.value) {
            $.ajax({
              type: 'get',              
              url: '{{ route('recieve.folder.delete') }}?folderId='+folderId,
                
                
                success: function(data) {
                    Swal.fire(
                        'Deleted!',
                        'Folder has been deleted.',
                        'success'
                    );
                   setTimeout(function () {
        
        location.reload(true);
      }, 1000);
      
   
                }
            });
        }
    });
});
$('#share-folder').click(function() {
    var folder_id = $(this).data('id');
     $("#folder").val(folder_id);
    });
</script>
@endpush