@extends('admin.layouts.chatlayout')
@section('contant')

<style>
  ::placeholder {
    color: red;
    opacity: .8; /* Firefox */
  }
</style>
<livewire:show-chat :chats="$chats"  :reciever="$reciever"/>
<!-- Modal -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
     <form id="form">
      <div class="modal-header">
       <button type="button" class="btn btn-danger" id="upload">Share</button>
     </div>
     <div class="modal-body">
      <table class="table">
        <thead>
          <tr>
            <th scope="col">#</th>
            <th scope="col">File Name</th>
            <th scope="col">File</th>
            <th scope="col">Select</th>
          </tr>
        </thead>
        <tbody>

          @foreach($files as $file)
          <tr>
            <th>{{$loop->index+1}}</th>
            <td>{{$file->title}}</td>
            <td class="p-0">

             @if($file->file_type=="image")
             <a href="{{ Storage::disk('s3')->temporaryUrl($file->image, '+2 minutes') }}" target="_blank"><img width="50px" height="50px" src="{{ Storage::disk('s3')->temporaryUrl($file->image, '+2 minutes') }}" ></a>

             @elseif($file->file_type=="video" )
             <a  href="#Geeks2{{$file->id}}" data-toggle="modal">
              video
            </a>
            <div id="Geeks2{{$file->id}}" class="modal fade">
              <div class="modal-dialog">
                <div class="modal-content">
                  <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button></div>
                    <div class="modal-body">
                      <video  controls  width="450" height="250">
                        <source id="Geeks3" src="{{ Storage::disk('s3')->temporaryUrl($file->image, '+2 minutes') }}" >
                        </video>

                      </div>
                    </div>
                  </div>
                </div>


                @elseif($file->file_type=="document" )
                <a href="{{ Storage::disk('s3')->temporaryUrl($file->image, '+2 minutes') }}" target="_blank">

                 <iframe width="100px" height="100px" src="{{ Storage::disk('s3')->temporaryUrl($file->image, '+2 minutes') }}" ></iframe> 
               </a>
               @elseif($file->file_type=="file" )

               <img width="50px" height="50px" src="{{asset('assets/img/file.png')}}"></img>
               @endif
             </td>
             <td><input type="checkbox" name="shared[]" value="{{$file->id}}" id="fileId">
              <input type="hidden" name="reciever" value="{{$reciever}}">
            </td>
          </tr>
          @endforeach

        </tbody>
      </table>
    </div>
  </form>
</div>
</div>
</div>
@endsection
@push('footer-script')
<script>
  $(document).ready(function() {

    $('#upload').on('click', function() {

      

      var formData= $('#form').serializeArray();
         $.ajaxSetup({
           headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
          });
          $.ajax({
              type: 'POST',              
              url: "{{ route('chat.file.store') }}",
               data: formData,               
               success: function(data) { 
                
                $('#form')[0].reset();
                $('#exampleModalCenter').modal('hide');
                
                }
            });
      });
      
    });


  </script>
  @endpush