<?php

namespace App\Http\Controllers;

use App\Models\Recieved;
use App\Models\File;
use App\Models\FileRequest;
use Illuminate\Http\Request;

class RecievedController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $id=auth()->user()->id;
        $recieveds=Recieved::Where('recieve_user_id',$id)->get();
        return view('admin.share.recieved',compact('recieveds'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    
        $fi_id=$request->file_id;
        $file_id=explode(",", $fi_id);
         $users=$request->shared;

        foreach($users as $user_id){
          foreach($file_id as $file){


            $reciver_user_id=$user_id;
          $data=array(
         'file_id'=>$file,
         'recieve_user_id'=>$reciver_user_id,
         'share_user_id'=>auth()->user()->id,
         'user_type'=>$request->user_type,
         );
        $recieved=Recieved::create($data);
        }

        }


        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Recieved  $recieved
     * @return \Illuminate\Http\Response
     */
    public function show(Recieved $recieved)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Recieved  $recieved
     * @return \Illuminate\Http\Response
     */
    public function edit(Recieved $recieved)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Recieved  $recieved
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Recieved $recieved)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Recieved  $recieved
     * @return \Illuminate\Http\Response
     */
    public function destroy(Recieved $recieved)
    {
        //
    }
    public function request_file_store(Request $request)
    {

        $file=FileRequest::where('id',$request->request_file)->first();
        
        $reciver_user_id=$file->request_userId;
         
       $data=array(
         'file_id'=>$request->shared_file,
         'recieve_user_id'=>$reciver_user_id,
         'share_user_id'=>auth()->user()->id,
         'user_type'=>1,
         );
        $recieved=Recieved::create($data);
       FileRequest::where('id',$request->request_file)->update([
           'status' => 'complete'
        ]);

        return redirect()->back();
    }
    public function request_file_store_device(Request $request)
    {
        $file=$request->file;
            $user_id=auth()->user()->id;
              

            
            $original_name=$file->getClientOriginalName();
            $filename = $user_id.'_'.$original_name;
            $e=$file->getClientOriginalExtension();
            $filesize = $file->getSize();
            $location=$file->storeAs('file-sharing',$filename,'s3');
            $units = ['Byte', 'KB', 'MB','GB'];
            $bytes=$filesize;
            for ($i = 0; $bytes > 1024; $i++) {
            $bytes /= 1024;
            }
            $size= round($bytes, 2) . ' ' . $units[$i];
        if($e=='jpg'||$e=='jpeg'||$e=='png'||$e=='webp'||$e=='gif'||$e=='tiff'||$e=='psd'||$e=='esp'||$e=='ai'){
            $file_type='image';
        }elseif($e=='mp4'||$e=='mov'||$e=='wmv'||$e=='avi'||$e=='avchd'||$e=='flv'||$e=='f4v'||$e=='swf'||$e=='mkv'||$e=='webm'||$e=='mpeg-2' ){
            $file_type='video';
        }elseif($e=='pdf'||$e=='docx'||$e=='doc'){
            $file_type='document';
        }else{
            $file_type='file';
        }


            $fileModel = new File;
            $fileModel->user_id=$user_id;
            $fileModel->extension=$e;
            $fileModel->file_type=$file_type;
            $fileModel->title = $original_name;
            $fileModel->size = $size;
            $fileModel->byte_size = $filesize;
            $fileModel->image = $location;
            $fileModel->save();
        

        $file=FileRequest::where('id',$request->request_file)->first();       
        $reciver_user_id=$file->request_userId;

         $data=array(
         'file_id'=>$fileModel->id,
         'recieve_user_id'=>$reciver_user_id,
         'share_user_id'=>auth()->user()->id,
         'user_type'=>1,
         );
        $recieved=Recieved::create($data);
       FileRequest::where('id',$request->request_file)->update([
           'status' => 'complete'
        ]);

        return response()->json(['success' => 'File deleted successfully.']);
    }
}
